# Code for "IoT" course

## Raspberry Pi

We connected a thermal sensor (LM75) via the I2c bus and a LED via
GPIO.

## Components

	- *common.rkt* :: This module contains string constants and
      structs that are used by the other modules. The idea is that we
      just send the structs via the /universe/ server rely on a common
      definition.
	  
	- *sys.rkt* :: This module hides the system calls to "i2cget" and
      "gpio" and provides a parameter `on-raspberry-pi?` that controls
      whether the system calls should be used or some "fake"
      temperature should be generated. This helps to run this module
      on your PC instead of a RaspberryPi.
	  
	- *pi1.rkt* :: Component to be run on the RaspberryPi (needs
	  GUI). It defines its ID (DEVICE-ID) as a simple string (that
	  should be unique over all connected units). The IP address of
	  the universe server is given in the source code as well (SERVER).
	
	- *monitor1.rkt* :: Component to be run on student's PC. It
      defines its own ID (MONITOR-ID) and the RaspberryPi it wants to
      subsribe to (TOPIC). The adress of the universe server is given in SERVER.
	
	- *broker.rkt*, *wall.rkt* :: Central components for instructor's PC.
	  
## How to get things running

	1. Connect a LM75 thermal sensor and LED to your RaspberryPi.
	
	2. Start `broker.rkt` as your server instance. 
	
	3. Copy `pi1.rkt`, `common.rkt` and `sys.rkt` on your Raspberry
       Pi. Make sure that SERVER and `on-raspberry-pi?` have the
       correct value. Then start 'pi1.rkt' (needs GUI). 
		
    4. Start a `monitor1.rk` with the correct TOPIC and SERVER.
	
	5. (Optional) Start `wall.rkt` for an overview; be sure to have
       SERVER and DEVICES set correctly.
	

