#lang htdp/bsl


(require "sys.rkt")       ;; contains functions for LM75, LED
(require "common.rkt")    ;; contains device struct
(require 2htdp/universe)
(require 2htdp/image)

(define HEIGHT 50)
(define WIDTH 600)
(define SERVER LOCALHOST)

;; Constant for this device's id
(define DEVICE-ID "pi01")

;; WorldState is a device state that consists of a timestamp, a temperature and a state of the LED
;; device? 

;; Changes state of led
;; WorldState new-state -> WorldState
(define (change-state ws new-state)
  (make-device (current-seconds) (get-temperature) (set-light new-state)))

;; Creates a data package from the world state (sending world state to server
;; WorldState -> package? 
(define (pack-state ws)
  (make-package ws
                (message DEVICE-ID MSG-PUBLISH ws)))              

;; Collects the relevant data from the sensor and the LED and forms the new world state
;; WorldState -> WorldState
(define (collect-state ws)
  (pack-state (make-device (current-seconds) (get-temperature) (get-light))))

;; Renders the world (prints some debugging information)
(define (render-pi ws)
  (overlay/align "left" "middle"
                 (text (format "Collecting data... [~a]" ws) 25 "black")
                 (empty-scene WIDTH HEIGHT)))

;; Receives message and responds
;; MSG-ID: Only send my own Id
;; MSG-CHANGE-STATE: Change state
;; WorldState -> HandlerResult (or/c WorldState package?)
(define (receive-message ws msg)
  (if (and (message? msg)
           (valid-message? msg))
      (cond
        [(equal? (message-type msg) MSG-ID)
         (make-package ws (message DEVICE-ID MSG-ID DEVICE-ID))]
        [(and (equal? (message-type msg) MSG-CHANGE-STATE)
              (change-device-state? (message-body msg)))
         (change-state ws (change-device-state-led (message-body msg)))]
        [else ws])
      ws))

;; Starts big-bang with an initial state
;; WorldState -> WorldState
(define (main start-ws)
  (big-bang start-ws
            (name DEVICE-ID)
            (on-receive receive-message)
            (register SERVER)
            (to-draw render-pi)
            (on-tick collect-state 1)))

(main #true)
